/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CToolbar.cpp,v 1.1 1999/09/12 04:29:50 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "CToolbar.h"
#include "UModuleInstance.h"

_USING_PGP

// Class CToolbar member functions

void 
CToolbar::Create(
	HWND		parent, 
	PGPUInt32	id, 
	PGPUInt32	style, 
	PGPInt32	xOffset, 
	PGPInt32	yOffset, 
	PGPInt32	width, 
	PGPInt32	height)
{
	pgpAssert(!WeSubclassed());
	pgpAssert(CWindow::IsWindow(parent));

	HWND	hWnd	= ::CreateWindowEx(WS_EX_TOOLWINDOW, TOOLBARCLASSNAME, 
		NULL, WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | style, xOffset, 
		yOffset, width, height, parent, reinterpret_cast<HMENU>(id), 
		UModuleInstance::Get(), NULL);

	if (IsNull(hWnd))
		THROW_ERRORS(kPGPError_Win32WindowOpFailed, GetLastError());

	Subclass(hWnd);
	ButtonStructSize(sizeof(TBBUTTON));
}
